﻿#include  "StdAfx.h"

#include  <szArchiveProperty.hpp>

SZ_NS_BEG(szpp)

ArchiveProperty::ArchiveProperty() :
  archiveComment(),
  compressedSize(0), uncompressedSize(0),
  numberOfItems(0), numberOfVolumes(0),
  bits()
{
}

ArchiveProperty::~ArchiveProperty()
{
}

ArchiveProperty::ArchiveProperty(const ArchiveProperty &rhs) :
  archiveComment(rhs.archiveComment),
  compressedSize(rhs.compressedSize), uncompressedSize(rhs.uncompressedSize),
  numberOfItems(rhs.numberOfItems), numberOfVolumes(rhs.numberOfVolumes),
  bits(rhs.bits)
{
}

ArchiveProperty &ArchiveProperty::operator=(const ArchiveProperty &rhs)
{
  if (this != &rhs)
  {
    archiveComment.assign(rhs.archiveComment);
    compressedSize = rhs.compressedSize;
    uncompressedSize = rhs.uncompressedSize;
    numberOfItems = rhs.numberOfItems;
    numberOfVolumes = rhs.numberOfVolumes;
    bits = rhs.bits;
  }
  return *this;
}

SZ_NS_END(szpp)
